#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <iomanip> // ?? ????????? setprecision (??? ?? ????????, ??? ???? ?? ?? ?????????)

using namespace std;

// ????????? ?? ???????????? ?????
struct Point {
    int x, y;
    Point(int x = 0, int y = 0) : x(x), y(y) {}
    
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
};

// ???????? ?? ???????????? ?????????? ?????????
int cross(const Point& o, const Point& a, const Point& b) {
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}

// ???????? ?? ???????????? ?????????? ???????
vector<Point> convexHull(vector<Point>& points) {
    sort(points.begin(), points.end());

    vector<Point> lower, upper;
    for (const auto& p : points) {
        while (lower.size() >= 2 && cross(lower[lower.size() - 2], lower[lower.size() - 1], p) <= 0) {
            lower.pop_back();
        }
        lower.push_back(p);
    }

    for (int i = points.size() - 1; i >= 0; i--) {
        while (upper.size() >= 2 && cross(upper[upper.size() - 2], upper[upper.size() - 1], points[i]) <= 0) {
            upper.pop_back();
        }
        upper.push_back(points[i]);
    }

    lower.pop_back(); // ???????? ????? ?? ???????
    upper.pop_back(); // ???????? ????? ?? ???????
    lower.insert(lower.end(), upper.begin(), upper.end());

    return lower;
}

// ???????? ?? ???????????? ???????? ????????
double polygonArea(const vector<Point>& points) {
    double area = 0;
    int n = points.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        area += points[i].x * points[j].y - points[i].y * points[j].x;
    }
    return abs(area) / 2.0;
}

// ???????? ???? ????????? ????? ????? ? ?????????? ????????? ????????
double convexHullAreaWithOneRemoved(vector<Point>& points) {
    double minArea = 1e9; // ??????? ????????? ????????
    int N = points.size();
    
    for (int i = 0; i < N; i++) {
        vector<Point> newPoints;
        for (int j = 0; j < N; j++) {
            if (i != j) {
                newPoints.push_back(points[j]);
            }
        }
        
        vector<Point> hull = convexHull(newPoints);
        minArea = min(minArea, polygonArea(hull));
    }

    return minArea;
}

int main() {
    int N;
    cin >> N;

    vector<Point> points(N);
    for (int i = 0; i < N; i++) {
        cin >> points[i].x >> points[i].y;
    }

    double result = convexHullAreaWithOneRemoved(points);
    cout << (int)result << endl;  // ???????? ??? ???? (??? ????????)

    return 0;
}